/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia;

import com.epherical.croptopia.Composter;
import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.ForgeAdapter;
import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.config.Config;
import com.epherical.croptopia.items.GuideBookItem;
import com.epherical.croptopia.items.SeedItem;
import com.epherical.croptopia.listeners.BiomeModification;
import com.epherical.croptopia.listeners.BlockBreakEvent;
import com.epherical.croptopia.listeners.EntitySpawn;
import com.epherical.croptopia.listeners.Harvest;
import com.epherical.croptopia.listeners.LootTableModification;
import com.epherical.croptopia.loot.AdditionalTableModifier;
import com.epherical.croptopia.loot.EntityModifier;
import com.epherical.croptopia.loot.SpawnChestModifier;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="croptopia")
public class CroptopiaForge {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SpawnChestModifier.Serializer SPAWN_CHEST_MODIFIER = new SpawnChestModifier.Serializer();
    private static final EntityModifier.Serializer ENTITY_MODIFIER = new EntityModifier.Serializer();
    private static final AdditionalTableModifier.Serializer ADDTIONAL_TABLE_MODIFIER = new AdditionalTableModifier.Serializer();
    public static Config config;
    public static CreativeModeTab CROPTOPIA_ITEM_GROUP;
    public static CroptopiaMod mod;
    private static boolean hasRun;

    public CroptopiaForge() {
        config = new Config();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(config::initConfig);
        MinecraftForge.EVENT_BUS.addListener(CroptopiaForge::onWorldLoad);
        MinecraftForge.EVENT_BUS.register((Object)new BiomeModification());
        MinecraftForge.EVENT_BUS.register((Object)new LootTableModification());
        MinecraftForge.EVENT_BUS.register((Object)new Harvest());
        MinecraftForge.EVENT_BUS.register((Object)new BlockBreakEvent());
        MinecraftForge.EVENT_BUS.register((Object)new EntitySpawn());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CroptopiaForge.config.config);
        EventListenerHelper.getListenerList(PlayerInteractEvent.RightClickBlock.class);
        CROPTOPIA_ITEM_GROUP = new CreativeModeTab("croptopia"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)Content.COFFEE);
            }
        };
        mod = new CroptopiaMod(new ForgeAdapter());
    }

    private void setup(FMLCommonSetupEvent event) {
        Composter.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        CroptopiaMod.cropBlocks.forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        colors.m_92589_((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.m_46113_(), CroptopiaMod.leafBlocks.toArray(new Block[0]));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.COOKING_POT));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.FOOD_PRESS));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.FRYING_PAN));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.MORTAR_AND_PESTLE));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterWaterItem", () -> new ItemStack((ItemLike)Content.WATER_BOTTLE));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterMilkItem", () -> new ItemStack((ItemLike)Content.MILK_BOTTLE));
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLDedicatedServerSetupEvent event) {
    }

    public static ResourceLocation createIdentifier(String name) {
        return new ResourceLocation("croptopia", name);
    }

    private static void modifyVillagerFoodItems() {
    }

    private static void modifyVillagerGatherables() {
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        if (!hasRun) {
            CroptopiaForge.modifyVillagerFoodItems();
            CroptopiaForge.modifyVillagerGatherables();
            hasRun = true;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            Content.registerBlocks((id, object) -> {
                object.setRegistryName(id);
                blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)object);
                return object;
            });
        }

        @SubscribeEvent
        public static void onItemRegister(RegistryEvent.Register<Item> itemRegister) {
            Content.GUIDE = new GuideBookItem(CroptopiaMod.createGroup());
            Content.GUIDE.setRegistryName(CroptopiaForge.createIdentifier("guide"));
            itemRegister.getRegistry().register((IForgeRegistryEntry)Content.GUIDE);
            Content.registerItems((id, item) -> {
                item.setRegistryName(id);
                itemRegister.getRegistry().register((IForgeRegistryEntry)item);
                if (item instanceof ItemNameBlockItem) {
                    ((ItemNameBlockItem)item).m_6192_(Item.f_41373_, item);
                }
                if (item instanceof SeedItem) {
                    SeedItem it = (SeedItem)((Object)item);
                    CroptopiaCropBlock block = (CroptopiaCropBlock)it.m_40614_();
                    block.setSeed(it);
                }
                return item;
            });
            ArrayList<SeedItem> chickenItems = new ArrayList<SeedItem>(CroptopiaMod.seeds);
            chickenItems.addAll(Arrays.stream(Chicken.f_28233_.m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toList()));
            Chicken.f_28233_ = Ingredient.m_43929_((ItemLike[])chickenItems.toArray(new ItemLike[0]));
            ArrayList<SeedItem> parrotItems = new ArrayList<SeedItem>(Parrot.f_29357_);
            parrotItems.addAll(CroptopiaMod.seeds);
            Parrot.f_29357_ = Sets.newHashSet(parrotItems);
            ArrayList<FarmlandCrop> pigItems = new ArrayList<FarmlandCrop>(Arrays.asList(Content.YAM, Content.SWEETPOTATO));
            pigItems.addAll(Arrays.stream(Pig.f_29458_.m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toList()));
            Pig.f_29458_ = Ingredient.m_43929_((ItemLike[])pigItems.toArray(new ItemLike[0]));
        }

        @SubscribeEvent
        public static void onLootRegister(RegistryEvent.Register<GlobalLootModifierSerializer<?>> register) {
            SPAWN_CHEST_MODIFIER.setRegistryName(new ResourceLocation("croptopia", "spawn_loot"));
            ENTITY_MODIFIER.setRegistryName(new ResourceLocation("croptopia", "entity_modifier"));
            ADDTIONAL_TABLE_MODIFIER.setRegistryName(new ResourceLocation("croptopia", "table_adder"));
            register.getRegistry().register((IForgeRegistryEntry)SPAWN_CHEST_MODIFIER);
            register.getRegistry().register((IForgeRegistryEntry)ENTITY_MODIFIER);
            register.getRegistry().register((IForgeRegistryEntry)ADDTIONAL_TABLE_MODIFIER);
        }
    }
}

